################################################################################
##                      Raspberry Pi Pico-IoT-Projekte
##
##                    Projekt DHT22-Sensordatenauswertung
## 
## IoT-Projekt 1:
## Der Sensor DHT22 (AM2302) ist ein Luftfeuchte- und Temperatursensor und in 
## diesem R-Skript werden die über das MicroPython-Programm Sensor_DHT22_P1.py
## gesammelten Daten beispielhaft ausgewertet.
## Dieses R-Skript stellt einen Einstieg in die Thematik dar und weitere und
## durchaus komplexere Skripte werden folgen. Es ist klar, die Daten können auch
## beispielsweise mit Python ausgewertet werden und dabei können die Pico-IoT-
## Projekte sicher eine Anregung sein.
## 
##
## Ad-Oculos-Projekt, https://www.faes.de/ad-oculos/
## Günter Faes
## Version 1.0, 19.07.2023
## R-Version: 4.3.1
## RStudio-Version: RStudio 2023.03.1+446 "Cherry Blossom"
##
################################################################################

## Pakete:
library(lubridate)    # Zeit-Berechnungen

################################################################################
## Beispieldaten:
# Diesen Daten wurden über das MicroPython-Programm Sensor_DHT22_P1.py gesammelt.

SensorDaten <- read.csv("Log_1_2023-06-26.csv")

################################################################################
## Datenübersicht:
# Es wird davon ausgegangen, dass die Datenstruktur bekannt ist. Trotzdem wird
# versucht, konzeptionell Allgemeingültigkeit in die Auswertung einfliessen zu
# lassen.

View(SensorDaten)      # Tabellarische Übersicht

## Kenndaten über alle Beobachtungen:
n_Beobachtungen <- length(SensorDaten[,1]); n_Beobachtungen
# Kenndaten über die Zeit:
Messfrequenz <- dmy_hms(SensorDaten[2,1]) - dmy_hms(SensorDaten[1,1])
Messdauer_h <- difftime(dmy_hms(SensorDaten[n_Beobachtungen,1]), dmy_hms(SensorDaten[1,1]), units = "hours")

# Temperatur:
T_MW <- mean(SensorDaten[,2], na.rm = TRUE)       # Mittelwert
T_Stabw <- sd(SensorDaten[,2], na.rm = TRUE)      # Standardabweichung
T_min <- min(SensorDaten[,2])                     # Klienste Beobachtung
T_max <- max(SensorDaten[,2])                     # Größte Beobachtung
cat("Mittlere Temperatur über alle Beobachtungen: ", round(T_MW, digits = 1), " °C, Standardabweichung: ", round(T_Stabw, digits = 2), " °C", "\n")
cat("Tiefste gemessene Temperatur: ", T_min, " °C", "\n")
cat("Höchste gemessene Temperatur: ", T_max, " °C", "\n")

# Luftfeuchtigkeit:
Feuchte_MW <- mean(SensorDaten[,3], na.rm = TRUE)
Feuchte_Stabw <- sd(SensorDaten[,3], na.rm = TRUE)
Feuchte_min <- min(SensorDaten[,3])
Feuchte_max <- max(SensorDaten[,3])
cat("Mittlere Feuchtigkeit über alle Beobachtungen: ", round(Feuchte_MW, digits = 1), " %", ", Standardabweichung: ", round(Feuchte_Stabw, digits = 2), " %", "\n")
cat("Tiefste gemessene Luftfeuchtigkeit: ", Feuchte_min, " %", "\n")
cat("Höchste gemessene Luftfeuchtigkeit: ", Feuchte_max, " %", "\n")

## Grafische Darstellung:
par(mfrow = c(2,1))  # Die 2 Ausgabefenster vorbereiten

Zeitstempel_Start <- SensorDaten[1,1]
Zeitstempel_Ende <- SensorDaten[n_Beobachtungen,1]
X_Label <- paste("Index Messwert, Start:", Zeitstempel_Start, ", Ende:", Zeitstempel_Ende)
Subtitle <- paste("Messdauer ", round(Messdauer_h, digits = 1), "Stunden, ", "Messfrequenz: ", Messfrequenz, " Sekunden")

# Temperatur:
plot(SensorDaten$Temperatur,
     main = "Temperaturverlauf über den gesamten Messzeitraum",
     sub =  Subtitle,
     ylab = "Temperatur °C",
     xlab = X_Label,
     type = "p",
     col = "red")

# Hinzufügen der Mittwelwertlinie:
abline(h = T_MW, lty = 2, col = "red")

# Luftfeuchtigkeit:
plot(SensorDaten$Luftfeuchtigkeit,
     main = "Luftfeuchtigkeitsverlauf über den gesamten Messzeitraum",
     sub =  Subtitle,
     ylab = "Luftfeuchtigkeit in %",
     xlab = X_Label,
     type = "p",
     col = "blue")

# Hinzufügen der Mittwelwertlinie:
abline(h = Feuchte_MW, lty = 2, col = "blue")


par(mfrow = c(1,1))   # Ausgangszustand Grafikfenster wieder herstellen

################################################################################
## Kenndaten für einen über den Index selektierten Zeitraum:

# Festlegen des Index-Bereiches:
Index_Anfang <- 13000
Index_Ende <- 15000

# Selektieren über den Indexbereiches:
Selektion_Index <- SensorDaten[Index_Anfang:Index_Ende, ]
View(Selektion_Index)

## Kenndaten über den selektierten Bereich:
n_Selektion <- length(Selektion_Index[,1]); n_Selektion
# Kenndaten über die Zeit:
Messdauer_Selektion_h <- difftime(dmy_hms(Selektion_Index[n_Selektion,1]), dmy_hms(Selektion_Index[1,1]), units = "hours")

# Temperatur:
T_S_MW <- mean(Selektion_Index[,2], na.rm = TRUE)       # Mittelwert
T_S_Stabw <- sd(Selektion_Index[,2], na.rm = TRUE)      # Standardabweichung
T_S_min <- min(Selektion_Index[,2])                     # Klienste Beobachtung
T_S_max <- max(Selektion_Index[,2])                     # Größte Beobachtung
cat("Mittlere Temperatur über den selektierten Beobachtungsbereich: ", round(T_S_MW, digits = 1), " °C, Standardabweichung: ", round(T_S_Stabw, digits = 2), " °C", "\n")
cat("Tiefste gemessene Temperatur: ", T_S_min, " °C", "\n")
cat("Höchste gemessene Temperatur: ", T_S_max, " °C", "\n")

# Luftfeuchtigkeit:
Feuchte_S_MW <- mean(Selektion_Index[,3], na.rm = TRUE)
Feuchte_S_Stabw <- sd(Selektion_Index[,3], na.rm = TRUE)
Feuchte_S_min <- min(Selektion_Index[,3])
Feuchte_S_max <- max(Selektion_Index[,3])
cat("Mittlere Feuchtigkeit über den selektierten Beobachtungsbereich: ", round(Feuchte_S_MW, digits = 1), " %", ", Standardabweichung: ", round(Feuchte_S_Stabw, digits = 2), " %", "\n")
cat("Tiefste gemessene Luftfeuchtigkeit: ", Feuchte_S_min, " %", "\n")
cat("Höchste gemessene Luftfeuchtigkeit: ", Feuchte_S_max, " %", "\n")

## Grafische Darstellung:
par(mfrow = c(2,1))  # Die 2 Ausgabefenster vorbereiten

Zeitstempel_Start_S <- Selektion_Index[1,1]
Zeitstempel_Ende_S <- Selektion_Index[n_Selektion,1]
X_Label <- paste("Index Messwert, Start:", Zeitstempel_Start_S, ", Ende:", Zeitstempel_Ende_S)
Subtitle <- paste("Messdauer ", round(Messdauer_Selektion_h, digits = 1), "Stunden, ", "Messfrequenz: ", Messfrequenz, " Sekunden")

# Temperatur:
plot(Selektion_Index$Temperatur,
     main = "Temperaturverlauf über den selektierten Beobachtungsbereich",
     sub =  Subtitle,
     ylab = "Temperatur °C",
     xlab = X_Label,
     type = "p",
     col = "red")

# Hinzufügen der Mittwelwertlinie:
abline(h = T_S_MW, lty = 2, col = "red")

# Luftfeuchtigkeit:
plot(Selektion_Index$Luftfeuchtigkeit,
     main = "Luftfeuchtigkeitsverlauf über den selektierten Beobachtungsbereich",
     sub =  Subtitle,
     ylab = "Luftfeuchtigkeit in %",
     xlab = X_Label,
     type = "p",
     col = "blue")

# Hinzufügen der Mittwelwertlinie:
abline(h = Feuchte_S_MW, lty = 2, col = "blue")


par(mfrow = c(1,1))   # Ausgangszustand Grafikfenster wieder herstellen


################################################################################
## Kenndaten für einen über die Zeit selektierten Zeitraum:

# Festlegen des Index-Bereiches:
Zeit_Anfang <- dmy_hms("27.06.2023 15:00:00")
Zeit_Ende <- dmy_hms("27.06.2023 16:00:00")

# Selektion über den obigen Zeitraum:
Selektion_Zeit <- SensorDaten[dmy_hms(SensorDaten$Zeitstempel) >= Zeit_Anfang & dmy_hms(SensorDaten$Zeitstempel) <= Zeit_Ende,]
View(Selektion_Zeit)

## Kenndaten über den selektierten Bereich:
n_SelektionZeit <- length(Selektion_Zeit[,1]); n_SelektionZeit
# Kenndaten über die Zeit:
Messdauer_Selektion_h <- difftime(dmy_hms(Selektion_Zeit[n_SelektionZeit,1]), dmy_hms(Selektion_Zeit[1,1]), units = "hours")

# Temperatur:
T_SZ_MW <- mean(Selektion_Zeit[,2], na.rm = TRUE)       # Mittelwert
T_SZ_Stabw <- sd(Selektion_Zeit[,2], na.rm = TRUE)      # Standardabweichung
T_SZ_min <- min(Selektion_Zeit[,2])                     # Klienste Beobachtung
T_SZ_max <- max(Selektion_Zeit[,2])                     # Größte Beobachtung
cat("Mittlere Temperatur über den selektierten Beobachtungsbereich: ", round(T_SZ_MW, digits = 1), " °C, Standardabweichung: ", round(T_SZ_Stabw, digits = 2), " °C", "\n")
cat("Tiefste gemessene Temperatur: ", T_SZ_min, " °C", "\n")
cat("Höchste gemessene Temperatur: ", T_SZ_max, " °C", "\n")

# Luftfeuchtigkeit:
Feuchte_SZ_MW <- mean(Selektion_Zeit[,3], na.rm = TRUE)
Feuchte_SZ_Stabw <- sd(Selektion_Zeit[,3], na.rm = TRUE)
Feuchte_SZ_min <- min(Selektion_Zeit[,3])
Feuchte_SZ_max <- max(Selektion_Zeit[,3])
cat("Mittlere Feuchtigkeit über den selektierten Beobachtungsbereich: ", round(Feuchte_SZ_MW, digits = 1), " %", ", Standardabweichung: ", round(Feuchte_SZ_Stabw, digits = 2), " %", "\n")
cat("Tiefste gemessene Luftfeuchtigkeit: ", Feuchte_SZ_min, " %", "\n")
cat("Höchste gemessene Luftfeuchtigkeit: ", Feuchte_SZ_max, " %", "\n")

## Grafische Darstellung:
par(mfrow = c(2,1))  # Die 2 Ausgabefenster vorbereiten

Zeitstempel_Start_SZ <- Selektion_Zeit[1,1]
Zeitstempel_Ende_SZ <- Selektion_Zeit[n_SelektionZeit,1]
X_Label <- paste("Index Messwert, Start:", Zeitstempel_Start_SZ, ", Ende:", Zeitstempel_Ende_SZ)
Subtitle <- paste("Messdauer ", round(Messdauer_Selektion_h, digits = 1), "Stunden, ", "Messfrequenz: ", Messfrequenz, " Sekunden")

# Temperatur:
plot(Selektion_Zeit$Temperatur,
     main = "Temperaturverlauf über den selektierten Beobachtungsbereich",
     sub =  Subtitle,
     ylab = "Temperatur °C",
     xlab = X_Label,
     type = "p",
     col = "red")

# Hinzufügen der Mittwelwertlinie:
abline(h = T_SZ_MW, lty = 2, col = "red")

# Luftfeuchtigkeit:
plot(Selektion_Zeit$Luftfeuchtigkeit,
     main = "Luftfeuchtigkeitsverlauf über den selektierten Beobachtungsbereich",
     sub =  Subtitle,
     ylab = "Luftfeuchtigkeit in %",
     xlab = X_Label,
     type = "p",
     col = "blue")

# Hinzufügen der Mittwelwertlinie:
abline(h = Feuchte_SZ_MW, lty = 2, col = "blue")


par(mfrow = c(1,1))   # Ausgangszustand Grafikfenster wieder herstellen

##### Skript-Ende #####

