#############################################################
# Ad-Olulos-Projekt: IoT-Simulation mit dem RPi Pico
#
#           Sensor DHT22 (Feuchte & Temperatur)
# 
# Projekt 1, die Basis:
# Die Messergebnisse Temperatur und Luftfeuchtigkeit werden
# mit Zeitstempel als Datei in den internen Pico-Speicher
# geschrieben.
#
# Günter Faes
# Ad-Oculos-Projekt: https://www.faes.de/ad-oculos/
# MicroPython-Version: 1.20.0
# Version: 0.3.5  15.07.2023
#############################################################

# Libraries importieren:
import utime                            # Zeit
import machine                          # Hardware, GPIO
import ssd1306                          # OLED-Display
from dht import DHT22                   # Temperatur- / Luftfeuchtesensor DHT22
import ds3231                           # RTC (Uhr)


## GPIO-Pin-Deklaration:
# GP-Pin 14: Ein = Führe Hauptproramm aus:
Button_PIN14 = machine.Pin(14, machine.Pin.IN, machine.Pin.PULL_DOWN)
# GP-Pin 15: Grüne Led zeigt Hauptprogrammausführung an:
LED_PIN15 = machine.Pin(15, machine.Pin.OUT)
# GP-Pin 11: Eingangssignal des DHT22-Sensors:
dht22_sensor = DHT22(machine.Pin(11, machine.Pin.IN, machine.Pin.PULL_UP))
# IC2_1 für die RTC festlegen:
rtc = ds3231.RTC(sda_pin = 26, scl_pin = 27, port = 1)

## Festlegung der OLED-Display(ssd1306)-Eigenschaften über I2C, GP0 & GP1:
sda0 = machine.Pin(0)
scl1 = machine.Pin(1)
i2c0 = machine.I2C(0, sda = sda0, scl = scl1, freq = 400000)
# Auflösung des Displays:
OLED_width = 128
OLED_height = 64
OLED = ssd1306.SSD1306_I2C(OLED_width, OLED_height, i2c0)

## --------------------- Funktionsbereich ----------------------

# Ausgabe auf dem OLED-Display:
def OLED_Ausgabe(text1 = "",
                  text2 = "",
                  text3 = "",
                  text4 = "",
                  text5 = "",
                  text6 = ""):
    
    # Display-Ausgabe:
    OLED.fill(0) # Display löschen
    OLED.show()
                
    OLED.text(text1, 0, 0, 1)
    OLED.text(text2, 0, 10, 1)
    OLED.text(text3, 0, 20, 1)
    OLED.text(text4, 0, 30, 1)
    OLED.text(text5, 0, 40, 1)
    OLED.text(text6, 0, 50, 1)
    
    
    OLED.show()

# -------------------------------------------------------------
# Temperatur- und Luftfeuchtigkeitsmessung mit DHT22 durchführen:

def SensorDHT22():
    
    dht22_sensor.measure()    # Messung durchführen
    # Werte an Rückgabevariablen übergeben:
    temp = dht22_sensor.temperature()
    humi = dht22_sensor.humidity()
    
    return temp, humi

# -------------------------------------------------------------

# ------------------ Ausführungsteil: -------------------------

FileOpen = False        # Zur Prüfung, ob die Datei zum Schreiben im Messzyklus offen ist
MesszyklusZeit = 0      # Inital-Messzyklus-Zeit, gilt nur beim Einschalten des Messvorganges
DateiBezeichnung = ""
ZyklusLogDateiNr = 1    # Initalwert der Logbuch-Datei-Nr.

# Die Ausführungschleife:
while True:
             
    #### Führe Hauptprogramm solange aus, bis Button_PIN14 == 0:         
    if Button_PIN14.value() == 1:
        
        # LED einschalten:
        LED_PIN15.value(1)
                                           
        # Lufttemperatur & Feuchtigkeit messen
        utime.sleep(MesszyklusZeit)
        F_Erg = SensorDHT22()
        Temperatur = str(F_Erg[0])
        Feuchtigkeit = str(F_Erg[1])
        
        # RTC auslesen:
        rtc_DatumZeit = rtc.ReadTime("DIN-1355-1+time") # Für Dateiausgabe
        rtc_Zeit = rtc.ReadTime("time")                 # Für OLED_Ausgabe
            
        OLED_Ausgabe(text1 = "Zeit: " + rtc_Zeit,
                     text2 = "T Grad C: " + Temperatur,
                     text3 = "Feuchtigk. %:",
                     text4 = Feuchtigkeit)
            
        # Datei-Zeichenkette erstellen:
        # Parametertrennung durch Komma
        publishingString = rtc_DatumZeit + "," + Temperatur + "," + Feuchtigkeit + "\n"
        
        # Test:
        # print(publishingString)
        
        # Nur mit erstem Durchlauf des Messzyklus durchführen:
        if FileOpen == False:
            
            # Datei erzeugen / schreiben:
            # Der Dateiname ist der erste Zeitstempel (ISO) des Messzykluses!
            DateiBezeichnung = "Log_" + str(ZyklusLogDateiNr) + "_" + rtc.ReadTime('ISO-8601') + ".csv"
            file = open(DateiBezeichnung, "w")
            FileOpen = True
            ZyklusLogDateiNr += 1
            
            # "Tabellen"-Überschrift erstellen:
            ErsteZeile = "Zeitstempel" + "," + "Temperatur" + "," + "Luftfeuchtigkeit" + "\n"
            file.write(ErsteZeile)
            file.flush()

        # Messwerte als Datei sichern:        
        file.write(publishingString)
        file.flush()       # Direktes schreiben, ohne close()!
        
        # Messzykluszeit auf Betriebszeit setzen, z. B. 3 Sekunden:
        MesszyklusZeit = 5
 
        
    else:
        
        #### Führe Standby-Code solange aus, bis Button_PIN14 == 0:
        # LED ausschalten:
        LED_PIN15.value(0)

        # Wenn der Pico im Standby-Modus gestartet wird, ist die Datei-Bezeichnung
        # noch leer, muss also abgefangen werden:
        if DateiBezeichnung != "":
            
            file.close()  # Datei schließen
            FileOpen = False

        
        MesszyklusZeit = 1
        utime.sleep(MesszyklusZeit)
        
        # Display-Ausgabe:
        OLED_Ausgabe(text1 = "Standby")

### Programm Ende ####
        


