################################################################################
##
##                  IoT-Projekte-Funktionssammlung 
## 
## 
## In dieser Datei werden die R-Funktion zu den IoT-Projekten gesammelt.
##
## Funktionen:
##
##            1. SendeMail(EreignisDaten, Betreff = "IoT-Ereignis")
##            2. SQLiteDBVerbindung(DB_Verz_Datei)
##               (Datenbankverbindung herstellen, Beispiel-Argument: "Verzeicnis/Datei.db")
##            3. DBDatenSchreiben(DBVerbindung, Tabelle, Daten)
##               (RW- und append-Modus)
##            4. PushDatenDB(DB_Verz_Datei, Tabelle, Daten)
##               (Schnelle DB-Schreibfunktion, "fire and forgett")
##            5. PullDatenDB
##
##
## Ad-Oculos-Projekt, https://www.faes.de/ad-oculos/
## Günter Faes
## Version 0.4, 29.01.2024
## R-Version: 4.3.2 (2023-06-16)
##
################################################################################

## Pakete:
library(sendmailR)    # Mail
library(curl)         # Mail
library(RSQLite)      # DMS RSQLite


################################################################################

"SendeMail" <- function(EreignisDaten, Betreff = "IoT-Ereignis")
{
  
  Nachricht <- paste("Zeitstempel/Messpunkt/Temperatur: ", EreignisDaten[1], EreignisDaten[3], EreignisDaten[5])
  
  Rueckgabe <- sendmail(from = "iot@faes.de",
                        to = "pus@faes.de",
                        subject = Betreff,
                        msg = Nachricht,
                        engine = "curl",
                        engineopts = list(username = "iot@faes.de", password ="---------"),
                        control = list(smtpServer = "smtp://smtp.ionos.de:587", verbose = FALSE)
  )
  
  return(Rueckgabe)
  
}

################################################################################

## SQLite: DB-Verbindung herstellen:

"SQLiteDBVerbindung" <- function(DB_Verz_Datei)
{
  
  DBVerbindung <- dbConnect(RSQLite::SQLite(), dbname = DB_Verz_Datei, SQLITE_RW)
  
  return(DBVerbindung)
  
}

################################################################################

## SQLite: Daten in Tabelle schreiben

"DBDatenSchreiben" <- function(DBVerbindung, Tabelle, Daten)
{
  
  dbWriteTable(DBVerbindung, Tabelle, Daten, append = TRUE)
  
}

################################################################################

## SQLite: Datenbank öffnen, Daten schreiben, DB schließen
# Die Daten werden über diese Funktion in die DB "gedrückt".
# (fire and forgett)

"PushDatenDB" <- function(DB_Verz_Datei, Tabelle, Daten)
{
  
  # Datenbankverbindung herstellen:
  DBVerbindung <- dbConnect(RSQLite::SQLite(), dbname = DB_Verz_Datei, SQLITE_RW)
  
  # Daten in Tabelle schreiben:
  dbWriteTable(DBVerbindung, Tabelle, Daten, append = TRUE)
  
  # Datenbank schliessen:
  dbDisconnect(DBVerbindung)
  
}

################################################################################

## SQLite: Datenbank öffnnen und aus einer Tabelle die angegebenen Zeilen
# lesen. (Komplettfunktion)

"PullDatenDB" <- function(DB_Verz_Datei, Tabelle, nZeilen = 10)
{
  
  # Datenbankverbindung herstellen:
  DBVerbindung <- dbConnect(RSQLite::SQLite(), dbname = DB_Verz_Datei, SQLITE_RW)
  
  # Abfrage-Zeichenkette erstellen:
  Abfrage <- paste0("SELECT * FROM ", "'", Tabelle, "'", "LIMIT ", "'", nZeilen, "'")
  
  # Abfrage durchführen:
  Rueckgabe <- dbGetQuery(DBVerbindung, Abfrage)
  
  return(Rueckgabe)
  
}


#### Ende Funktionssammlung ####
