"RunCollect" <- function(InputDatei = "PicoDaten.csv",
                         DBVerzeichnis = "PicoDatenDB",
                         DBBezeichnung = "PicoDaten.db",
                         DBTabelle = "PicoDaten",
                         Grafiktitel = "Verlauf Sensordaten",
                         Signalbezeichnung = "Temperatur in °C",
                         minSignal = 0,
                         maxSignal = 80,
                         nXAchse = 50)
{
  
################################################################################
##                      Raspberry Pi Pico-IoT-Projekte
##
##                    Projekt OneWire-Sensordatenauswertung
##                    und Daten in einer SQLite-DB speichern
## 
## IoT-Projekt 4:
## 
## In diesem Projekt werden die vom Pi Pico über MQTT gesendeten Sensordaten
## auf dem Raspberry Pi 4B über Node-RED empfangen und jeder Sensordatensatz
## als EINE Zeile im csv-Format gespeichert. Diese Datei wird von diesem R-Skript
## ausgelesen, die Daten ein wenig verarbeitet und und zur weiteren nach-
## träglichen Analyse in einer SQLite-Datenbank gesammelt.
##
## Dieses R-Skript ist als R-Funktion angelegt und nutzt weiter Funktion
## aus IoT_Funktionen.R.  
##
## Ad-Oculos-Projekt, https://www.faes.de/ad-oculos/
## Günter Faes
## Version 0.1.3, 23.02.2024
## R-Version: 4.3.2  (2023-06-16)     
##
################################################################################

## Pakete:

  
################################################################################
  
## Variablenindizierung:

# Datei:
Verzeichnis <- getwd()             # Verzeichnis der Datendatei
DatenDatei <- InputDatei           # Bezeichnung der aktuellen Datendatei
Verz_Datei <- paste0(Verzeichnis,"/",DatenDatei)

# Grafik:
Titel <- Grafiktitel               # Grafiktitel
Y_Titel <- Signalbezeichnung       # Titel Y-Achse
neueGrafik <- TRUE                 # Soll Plot ausgeführt werden?
GrafikIndexZaehler <- 0            # Wurde nXAchse schon erreicht?
Y_min <- minSignal                 # ylim unten
Y_max <- maxSignal                 # ylim oben
MwSymbol <- 1                      # Grafisches Messwertsymbol
SymbolFarbeS1 <- "black"           # Farbe Symbol 1
SymbolFarbeS2 <- "black"           # Farbe Symbol 2

# DMS:
DB_Verz_Datei <- paste0(DBVerzeichnis, "/", DBBezeichnung)
DBVerbindung <- NULL

# Allgemein:
SensorDaten <- NULL
n_Beobachtungen <- 0               # Anzahl der eingelesenen Messwerte
MailFlag_MS1 <- 0                  # Messstelle 1: Mail versendet?
MailFlag_Ms2 <- 0                  # Messstelle 2: Mail versendet?


## Benötigte Funktionen laden:
source("IoT_Funktionen.R")

######################### Ausführungsteil ######################################
   
## Dateneinlesen als Endlosschleife:
repeat {
  
    # Aktuelle Sensordaten einlesen:
    if (file.exists(Verz_Datei) & (file.size(DatenDatei) > 0)) {
    
      SensorDatenAktuell <- read.table(Verz_Datei, sep = ",")
    
      # Eingelesene Sensordaten pro Sensor separieren:
      if (is.null(SensorDaten)) {  # Df noch nicht vorhanden, anlegen:
        
        SensorDaten <- SensorDatenAktuell[1:9]
        SensorDaten[nrow(SensorDaten)+1,] <- SensorDatenAktuell[10:18]
        names(SensorDaten) <- c("Datum", 
                                "Sensor", 
                                "Messpunktbez", 
                                "Messzyklus_sek", 
                                "Temperatur_C", 
                                "ESW", 
                                "Warngrenze_unten",
                                "Warngrenze_oben",
                                "EreignisFlag")
        
        # In DB schreiben:
        PushDatenDB(DB_Verz_Datei, DBTabelle, SensorDaten)
        
      } else {   # Df vorhanden, Einträge werden durch die neuen Daten überschreiben:
        
        SensorDaten[1,] <- SensorDatenAktuell[1:9]
        SensorDaten[2,] <- SensorDatenAktuell[10:18]
        
        # In DB schreiben:
        PushDatenDB(DB_Verz_Datei, DBTabelle, SensorDaten)
        
      }
      
      # Aufräumen: Input-Datei löschen
      file.remove(Verz_Datei)

      # GrafikIndexZaehler prüfen, ob eine neue Grafik über plot
      # erstellt werden muss:
      GrafikIndexZaehler <- GrafikIndexZaehler + 1
      if (GrafikIndexZaehler > nXAchse) 
      {
        # Vorbereitungen, um eine neue Grafik über plot zu erstellen:  
        GrafikIndexZaehler <- 1
        dev.off()                # Vorhandene Grafik löschen
        
        neueGrafik <- TRUE       # Flag zur grafischen Darstellung setzen
        
      }
      
      # Grafische Darstellung:
      if (neueGrafik == TRUE) 
      {
        
        # Sensordaten jeweils separat in einem eigenen Grafikbereich darstellen:
        par(mfrow = c(1,2))
        
        # Mit dem ersten Messpunkt die Grafik im 1. Fenster erstellen:
        plot(n_Beobachtungen, SensorDaten[1,5],
             main = paste0(Titel, " ", SensorDaten[1,3]),
             xlab = "Messpunkt-Nr.",
             ylab = Y_Titel,
             xlim = c(n_Beobachtungen,n_Beobachtungen + nXAchse),
             ylim = c(Y_min, Y_max),
             type = "p",
             pch = MwSymbol,
             col = SymbolFarbeS1)
        
        # Warngrenzen einzeichnen:
        abline(h = SensorDaten[1, 7], col = "blue")  # Unten
        abline(h = SensorDaten[1, 8], col = "red")   # Oben
        
        # Mit dem ersten Messpunkt die Grafik im 2. Fenster erstellen::
        plot(n_Beobachtungen, SensorDaten[2,5],
             main = paste0(Titel, " ", SensorDaten[2,3]),
             xlab = "Messpunkt-Nr.",
             ylab = Y_Titel,
             xlim = c(n_Beobachtungen,n_Beobachtungen + nXAchse),
             ylim = c(Y_min, Y_max),
             type = "p",
             pch = MwSymbol,
             col = SymbolFarbeS2)

        # Warngrenzen einzeichnen:
        abline(h = SensorDaten[2, 7], col = "blue")  # Unten
        abline(h = SensorDaten[2, 8], col = "red")   # Oben
        
        neueGrafik <- FALSE   # Grafik wurde erstellt ...
        
      } else {
        
        # Grafik erstellt und nun nur noch Datenpunkte hinzufügen:
        # 1. Fenster:
        par(mfg = c(1,1)) # 1. Fenster ansprechen
        
        # Ereignis behandeln:
        if (SensorDaten[1,9] == "Ja")
        {
          SymbolFarbeS1 <- "red"
          MwSymbol <- 16
          
          # Ereignismail schreiben:
          # Es soll nur 1 Mail pro Ereignis geschrieben werden!
          if (MailFlag_MS1 == 0)
          {
          temp <- SendeMail(SensorDaten[1,],
                            Betreff <- paste0("Ereignis für Messpunkt ", SensorDaten[1,3]))
          
          MailFlag_MS1 <- 1 # Mail versendet
          }
          
        } else {
          
          SymbolFarbeS1 <- "black"
          MwSymbol <- 1
          
          # Mailflag zurücksetzen:
          MailFlag_MS1 <- 0
          
        }
        
        points(n_Beobachtungen, SensorDaten[1,5],
               type = "p",
               pch = MwSymbol,
               col = SymbolFarbeS1)
        
        
        # 2. Fenster:
        par(mfg = c(1,2)) # 2. Fenster ansprechen
        
        if (SensorDaten[2,9] == "Ja")
        {
          SymbolFarbeS2 <- "red"
          MwSymbol <- 16

          # Ereignismail schreiben:
          # Es soll nur 1 Mail pro Ereignis geschrieben werden!
          if (MailFlag_Ms2 == 0)
          {
          temp <- SendeMail(SensorDaten[2,],
                            Betreff <- paste0("Ereignis für Messpunkt ", SensorDaten[2,3]))
          
          MailFlag_Ms2 <- 1 # Mail versendet
          }

        } else {
          
          SymbolFarbeS2 <- "black"
          MwSymbol <- 1
          
          # Mailflag zurücksetzen:
          MailFlag_Ms2 <- 0
          
        }
        
        points(n_Beobachtungen, SensorDaten[2,5],
               type = "p",
               pch = MwSymbol,
               col = SymbolFarbeS2)
      
                
      } # Ende grafische Darstellung
      
      n_Beobachtungen <- n_Beobachtungen + 1
      
    } # Ende if Sensordaten einlesen
  
  
    # repeat-Abbruchkriterium prüfen:
    
  
  } # Repeat-Ende

} # Funktionsende

#### Skript-Ende #####


  