  ################################################################################
  ##                      Raspberry Pi Pico-IoT-Projekte
  ##
  ##                   SQLite-Test-Funktion Raspberry Pi 4B
  ## 
  ## IoT-Projekt 4: POC "SQLite Raspberry Pi 4B, Abfrage über SSH"
  ## 
  ## Dieses Skript ist Bestandteil des 4. IoT-Projektes, um die Verwendung 
  ## einer SQLite-Datenbank auf dem Rspberry Pi 4B zu testen.
  ## Die SQLite-DB befindet sich auf dem Pi 4B und dieses R-Skript läuft
  ## auf einem Windows 10/11-Rechner. Von dem Windows-Rechner soll via SSH
  ## auf die DB des Pi's 4B zugegriffen werden.
  ##
  ## Siehe auch: https://www.sqlite.org 
  ##
  ## Ad-Oculos-Projekt, https://www.faes.de/ad-oculos/
  ## Günter Faes
  ## Version 0.0.7, 04.04.2024
  ## R-Version: 4.3.3  (2024-02-29)   
  ##
  ################################################################################

  ## Pakete laden:
  library(ssh)

  ################################################################################
  ##                       Variablenindizierung
  ################################################################################
  
  # Datenbank:
  DBVerzeichnis = "/media/pi/Nano_SSD/Pico-Daten/PicoDatenDB"
  DBBezeichnung = "PicoDaten.db"
  DBTabelle = "PicoDaten"
  Abfrage <- ""
  Ergebnis <- NULL
  
  
  # Datenbank / -verbindung:
  session <- ""
  DBName <- paste0(DBVerzeichnis,"/",DBBezeichnung)
  
  ################################################################################
  ##                       SSH-Verbindung zur DB
  ################################################################################
  
  ## SSH-Verbindung herstellen:
  session <- ssh::ssh_connect(host = "pi@192...", passwd = "xxxx")
  
  ## Referenzabfrage:
  # Abfrage <- paste0("sqlite3 /media/pi/Nano_SSD/Pico-Daten/PicoDatenDB/PicoDaten.db 'SELECT * FROM PicoDaten'")
  
  ## Verschiedene Abfrage-Arten:
  # Ereignis-Abfrage:
      # Parameter:
      # DBSpalte <- "EreignisFlag"
      # Parameter = "\"Ja\""         # Ereignis = "Ja"
  # Abfrage <- paste0("sqlite3 ", DBName, " 'SELECT * FROM ", DBTabelle, " WHERE ", DBSpalte,"=", Parameter, "'")
  
  # Datums-Abfrage:
      # Parameter:
       DBSpalte <- "Datum"
       vonParameter = "\"2024-02-23 20:00:00\"" # Selektionszeitraum ab ...
       bisParameter = "\"2024-02-23 20:05:00\"" # Selektionszeitraum bis ...
       # Parameter = "2024-02-23"
  
  # Abfrage von ... bis Ende:
  # Abfrage <- paste0("sqlite3 ", DBName, " 'SELECT * FROM ", DBTabelle, " WHERE ", DBSpalte," >= ", Parameter, "'")
  # Abfrage von ... bis ...:
  Abfrage <- paste0("sqlite3 ", DBName, " 'SELECT * FROM ", DBTabelle, " WHERE ", DBSpalte," BETWEEN ", vonParameter, " AND ", bisParameter, "'")
  
  # Gesamten Inhalt abfragen:
  # Abfrage <- paste0("sqlite3 ", DBName, " 'SELECT * FROM ", DBTabelle,"'")

  
  # Abfrage durchführen:
  Ergebnis <- ssh::ssh_exec_internal(session, command = Abfrage)
  
  ## SSH-Verbindung schließen:
  ssh_disconnect(session)
  
  ################################################################################
  ##                      Abfrageergebnis verarbeiten
  ################################################################################
  
  ## Abfrage-Ergebnis transformieren:
  # Daten von Byte-Format nach Text-Format wandeln:
  Temp <- rawToChar(Ergebnis$stdout); Temp
  # Ausgabe in Zeilen und Spalten trennen:
  AbfrageDaten <- strsplit(Temp, "\n"); AbfrageDaten
  # Anzahl abgefragte Zeilen feststellen:
  n_DatenZeilen <- length(AbfrageDaten[[1]][])
  
  # |-Zeichen gegen Komma tauschen:
  AbfrageDaten <- gsub("\\|", ",", AbfrageDaten[[1]][])
  
  ## Auf dem Weg zum DataFrame:
  Start <- 1
  Ende <- n_DatenZeilen
  AbfrageDF <- NULL

  
  # Zeilenweise den DataFrame zusammen basteln:
  for(i in Start:Ende)
  {
    
    TempDF <- unlist(strsplit(AbfrageDaten[i:i], "[,]"))
    TempDF <- data.frame(rbind(TempDF))
    row.names(TempDF) <- NULL
    
    
    # DataFrame erstellen:
    if (i == 1) {
      
      AbfrageDF <- TempDF

    } else {
      
      # Folgeeinträge:
      AbfrageDF[nrow(AbfrageDF)+1,] <- TempDF
      
    }
    
  } # for-Ende
  
  SpaltenBezeichnungen <- c("Datum", 
                            "Sensor", 
                            "Messpunktbez", 
                            "Messzyklus_sek", 
                            "Temperatur_C", 
                            "ESW", 
                            "Warngrenze_unten",
                            "Warngrenze_oben",
                            "EreignisFlag")
  
  
  names(AbfrageDF) <- SpaltenBezeichnungen
  View(AbfrageDF)
  


#### Skript-Ende #####
